# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    AI-Genetic
%define upstream_version 0.05

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_11

Summary:    A class that implements various selection operators
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/AI/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch: noarch
Source44: import.info

%description
This module implements a Genetic Algorithm (GA) in pure Perl. Other Perl
modules that achieve the same thing (perhaps better, perhaps worse) do
exist. Please check CPAN. I mainly wrote this module to satisfy my own
needs, and to learn something about GAs along the way.

*PLEASE NOTE:* As of v0.02, AI::Genetic has been re-written from scratch to
be more modular and expandable. To achieve this, I had to modify the API,
so it is not backward-compatible with v0.01. As a result, I do not plan on
supporting v0.01.

I will not go into the details of GAs here, but here are the bare basics.
Plenty of information can be found on the web.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes README
%perl_vendor_privlib/*




%changelog
