# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTTP/Request.pm) perl(LWP/UserAgent.pm) perl(Modern/Perl.pm) perl(Test/More.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name API-DirectAdmin
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: interface to the DirectAdmin Hosting Panel API ( http://www.directadmin.com )
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CH/CHIPSOID/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use API::DirectAdmin;
 
 my %%auth = (
    auth_user   => 'admin_name',
    auth_passwd => 'admin_passwd',
    host        => '11.22.33.44',
 );

 # init
 my $da = API::DirectAdmin->new(%%auth);

 ### Get all panel IP
 my $ip_list = $da->ip->list();

 unless ($ip_list && ref $ip_list eq 'ARRAY' && scalar @$ip_list) {
    die 'Cannot get ip list from DirectAdmin';
 }

 my $ip  = $ip_list->[0];
 my $dname  = 'reg.ru';
 my $user_name = 'user1';
 my $email = 'user1@example.com';
 my $package = 'newpackage';

 my $client_creation_result = $da->user->create( {
    username => $user_name,
    passwd   => 'user_password',
    passwd2  => 'user_password',
    domain   => $dname,
    email    => $email,
    package  => $package,
    ip       => $ip,
 });

 # Switch off account:
 my $suspend_result = $da->user->disable( {
    select0 => $user_name,
 } );

 if ( $suspend_result->{error} == 1 ) {
    die "Cannot  suspend account $suspend_result->{text}";
 }



 # Switch on account
 my $resume_result = $da->user->enable( {
    select0 => $user_name,
 } );

 if ( $resume_result->{error} == 1 ) {
    die "Cannot Resume account $resume_result->{text}";
 }



 # Delete account
 my $delete_result = $da->user->delete( {
    select0 => $user_name,
 } );

 if ( $delete_result->{error} == 1 ) {
    die "Cannot delete account $delete_result->{text}";
 }
 
 # Custom request
 my %%params = (
    action  => 'package',
    package => 'package_name',
    user    => 'username',
 );

 my $responce = $da->query(
    command        => 'CMD_API_MODIFY_USER',
    method	   => 'POST',
    params         => \%%params,
    allowed_fields => 'action
		       package
		       user',
 );


%prep
%setup -n %module_name

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc .git/description README Changes
%perl_vendor_privlib/A*

%changelog
