%define module_name API-INSEE-Sirene
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Status.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(POSIX.pm) perl(Switch.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4.04
Release: alt1
Summary: An interface for the Sirene API of INSEE
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CP/CPANLNCSA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to interact with the Sirene API of INSEE (Institut National de la Statistique et des a'tudes a'conomiques) in France.

It contains a set of functions that can perform searches on INSEE's database to get some information about french entreprises like their SIREN number, company name, company headquarters address, etc.

The terms "enterprise", "legal unit" and "establishment" used in this documentation are defined at the INSEE website in the following pages:

=over 4

=item *

Enterprise definition:

https://www.insee.fr/en/metadonnees/definition/c1496

=item *

Legal unit definition:

https://www.insee.fr/en/metadonnees/definition/c1044

=item *

Establishment definition:

https://www.insee.fr/en/metadonnees/definition/c1377

=back

Here is the documentation with among others all fields names:

=over 4

=item *

https://api.insee.fr/catalogue/site/themes/wso2/subthemes/insee/pages/item-info.jag?name=Sirene&version=V3&provider=insee#tab2

=back

Please note that this API is french so all fields names used in function calls are in french.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
