Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(CGI/Carp.pm) perl(CGI/Cookie.pm) perl(GD.pm) perl-podlators
# END SourceDeps(oneline)
%filter_from_requires /^perl.GFF.pm./d
%add_findreq_skiplist %perl_vendor_privlib/Ace/Browser/* 
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Ace
Version:        1.92
Release:        alt2_49
Summary:        Perl module for interfacing with ACE bioinformatics databases
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/AcePerl
Source0:        https://cpan.metacpan.org/modules/by-module/Ace/AcePerl-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(Pod/Html.pm)
BuildRequires:  sed
Source44: import.info
%filter_from_requires /:__requires_exclude\|}perl(Ace.Browser.LocalSiteDefs.pm)/d

%description
AcePerl is a Perl interface for the ACEDB object-oriented database.
Designed specifically for use in genome sequencing projects, ACEDB
provides powerful modeling and management services for biological and
laboratory data.




%prep
%setup -q -n AcePerl-%{version}
# remove all execute bits from the doc stuff and fix interpreter
# so that dependency generator doesn't try to fulfill deps
find examples -type f -exec chmod -x {} 2>/dev/null ';'
find examples -type f -exec sed -i 's#/usr/local/bin/perl#/usr/bin/perl#' {} 2>/dev/null ';'

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS" NO_PACKLIST=1 NO_PERLLOCAL=1 << EOF
1
n
EOF
%{make_build}

%install
%{makeinstall_std}
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

## disable tests because they require network access
%check
%{?_with_check:make test || :}

%files
%doc examples
%doc ChangeLog DISCLAIMER.txt README README.ACEBROWSER
%{_bindir}/*
%{perl_vendor_privlib}/*

%changelog
