# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(FileHandle.pm) perl(Filter/Simple.pm) perl(Module/Signature.pm) perl(Socket.pm) perl(Tie/Handle.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Acme-Brainfuck
%define upstream_version 1.1.1

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Embed Brainfuck in your perl code
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Acme/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Module/Build/Compat.pm)
BuildArch: noarch
Source44: import.info

%description
Brainfuck is about the tiniest Turing-complete programming language you can
get. A language is Turing-complete if it can model the operations of a
Turing machine--an abstract model of a computer defined by the British
mathematician Alan Turing in 1936. A Turing machine consists only of an
endless sequence of memory cells and a pointer to one particular memory
cell. Yet it is theoretically capable of performing any computation. With
this module, you can embed Brainfuck instructions delimited by whitespace
into your perl code. It will be translated into Perl as parsed. Brainfuck
has just just 8 instructions (well more in this implementation, see the
/"Extensions to ANSI Brainfuck" manpage below.) which are as follows

Instructions
    * + Increment

      Increase the value of the current memory cell by one.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

#%check
#%make test

%install
%makeinstall_std

%files
%doc Changes META.yml README SIGNATURE
%perl_vendor_privlib/*



%changelog
