%define module_name Acme-CPANModules-Assert
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Assertion
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-Assert

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Assertion.

Assertion is a check statement that must evaluate to true or it will abort
program's execution. It is useful during development/debugging:

 assert("there must be >3 arguments", sub { @args > 3 });

In production code, compilers ideally do not generate code for assertion
statements so they do not have any impact on runtime performance.

In the old days, you only have this alternative to do it in Perl:

 assert(...) if DEBUG;

where `DEBUG' is a constant subroutine, declared using:

 use constant DEBUG => 0;

or:

 sub DEBUG() { 0 }

The perl compiler will optimize away and remove the code entirely when `DEBUG'
is false. But having to add `if DEBUG' to each assertion is annoying and
error-prone.

Nowadays, you have several alternatives to have a true, C-like assertions. One
technique is using the Devel::Declare manpage (e.g. the PerlX::Assert manpage). Another technique is
using the B::CallChecker manpage (e.g. the Assert::Conditional manpage).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/A*

%changelog
