%define module_name Acme-CPANModules-ReadingFilesBackward
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Reading files backward (in reverse)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-ReadingFilesBackward

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Reading files backward (in reverse).

Probably the fastest way, if you are on a Unix system, is to use the tac
command, which can read a file line by line in reverse order, or paragraph by
paragraph, or character by character, or word by word, or by a custom separator
string or regular expression. Example for using it from Perl:

 open my $fh, "tac /etc/passwd |";
 print while <$fh>;

Another convenient way is to use the Perl I/O layer the PerlIO::reverse manpage. It
only does line-by-line reversing, but you can use the regular Perl API. You
don't even have to `use' the module explicitly (but of course you have to get it
installed first):

 open my $fh, "<:reverse", "/etc/passwd";
 print while <$fh>;

If your file is small (fits in your system's memory), you can also slurp the
file contents first into an array (either line by line, or paragraph by
paragraph, or what have you) and then simply `reverse' the array:

 open my $fh, "<", "/etc/passwd";
 my @lines = <$fh>;
 print for reverse @lines;

If the above solutions do not fit your needs, there are also these modules which
can help: the File::ReadBackward manpage, the File::Bidirectional manpage. File::ReadBackward
is slightly faster than File::Bidirectional, but File::Bidirectional can read
forward as well as backward. I now simply prefer PerlIO::reverse because I don't
have to use a custom API for reading files.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
