%define module_name Acme-CPANModules-RemovingElementsFromArray
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(alias/module.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: List of modules to help remove elements from array
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-RemovingElementsFromArray

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Perl provides several ways to remove elements from an array. `shift' removes one
element from the beginning, `pop' removes one element from the end, and `splice'
can remove a slice of array (and insert another list in its place). There's also
the venerable `grep', which lets you filter a list with a user-supplied code.
While this does not directly modify an array, you can simply assign the new
filtered values to the array. And I might just as well mention array slice
(`@ary[1,3,4]' or `@ary[1..4]') to just pick the range of elements you want by
their indices.

In addition to the above, there are also other modules which provide some
convenience.

Removing duplicate items

the List::Util manpage provides `uniq' (as well as `uniqnum', `uniqint', `uniqstr')
to remove duplicate items from a list. There's also the List::Util::Uniq manpage
providing `dupe', `dupenum', `dupeint', and `dupestr', which return the
duplicates instead.

Removing overlapped items

the Array::OverlapFinder manpage lets you find overlapping items from a series of
arrays and optionally remove them.

Variations of `grep'

Some modules offer variations of `grep'. For example, the Array::KeepGrepped manpage
keeps the elements that are filtered out instead those that match the grep
expression. the List::Util::sglice manpage offers `sglice', which removes elements that
matches user-supplied code, except that `sglice' (like `splice') allows you to
specify a limit to the number of elements to remove.

mapslice

the List::Util::mapsplice manpage offers `mapsplice', which removes a slice of array
but lets you replace each element with new elements using Perl code.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/A*

%changelog
