%define module_name Acme-CPANModules-WorkingWithCSV
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Working with CSV (comma-separated value) data in Perl
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-WorkingWithCSV

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The following are tools (modules and scripts) to work with the CSV format:

Parsing

First things first, the most important module to work with CSV in Perl is
the Text::CSV manpage (which will use the Text::CSV_XS manpage backend when possible but fall
back to the Text::CSV_PP manpage otherwise). It's not in core, but only a cpanm command
away.

Generating CSV from Perl array/structure

the Text::CSV manpage (as well as the Text::CSV_XS manpage) can render a line of CSV from Perl
array(ref) with their `say()' method.

the dd2csv manpage from the App::CSVUtils manpage

the Perinci::CmdLine manpage framework can render function result (CLI output) as CSV.

Converting to/from other formats

*INI*: the ini2csv manpage from the App::TextTableUtils manpage

*TSV*: the csv2tsv manpage and Lthe tsv2csv manpage from the App::CSVUtils manpage

*LTSV*: the csv2ltsv manpage from the App::CSVUtils manpage and Lthe ltsv2csv manpage from
the App::LTSVUtils manpage

*XLS* and *XLSX*: the csv2tsv manpage and the tsv2csv manpage from the App::CSVUtils manpage

*JSON*: the csv2json manpage and the json2csv manpage from the App::TextTableUtils manpage

*Markdown table*: the csv2mdtable manpage from the App::TextTableUtils manpage

*Org table*: the csv2orgtable manpage from the App::TextTableUtils manpage

*SQLite database*: the csv2sqlite manpage from the App::SQLiteUtils manpage

Rendering as text/ASCII table

the csv2texttable manpage from the App::TextTableUtils manpage

Changing field separator character, field quote character, and/or escape character

the csv-csv manpage from the App::CSVUtils manpage

Adding/removing columns

the csv-add-field manpage, the csv-delete-field manpage, the csv-select-fields manpage from
the App::CSVUtils manpage

Processing columns of CSV with Perl code

the csv-munge-field manpage from the App::CSVUtils manpage

Processing rows of CSV with Perl code

Aside from the obvious the Text::CSV manpage, you can also use the csv-each-row manpage,
the csv-munge-row manpage, the csv-mp manpage from ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/A*

%changelog
