# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Filter/Simple.pm) perl(Hook/LexWrap.pm) perl(Module/Build.pm) perl(YAML.pm) perl(subs.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Acme-ComeFrom
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Parallel Goto-in-reverse
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AU/AUDREYT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
INTERCAL programmers have for a long time monopolized the enormously
powerful construct `COME FROM', both as a flow-control replacement to
`goto', and as a simple way to mark parallel execution branches in
the multi-thread variant.

But now, with Acme::ComeFrom, we Perl hackers can finally be on par
with them in terms of wackiness, if not in obfuscation.

Just like `goto', `comefrom' comes in three different flavors:

=over 4

=item comefrom LABEL

The `comefrom-LABEL' form finds the statement labeled with `LABEL'
and jumps to the `comefrom' each time just *before* that statement's
execution.  The `comefrom' may not be inside any construct that
requires initialization, such as a subroutine or a `foreach' loop,
unless the targeting `LABEL' is also in the same construct.

=item comefrom EXPR

The `comefrom-EXPR' form expects a label name, whose scope will be
resolved dynamically.  This allows for computed `comefrom's by
checking the `EXPR' before every label (a.k.a. watchpoints), so
you can write:

    # $i below evaluates in the LABEL's scope
    comefrom ("FOO", "BAR", "GLARCH")[$i];

Starting from version 0.05, the value of EXPR is evaluated each time,
instead of the old *frozen at the first check* behaviour.  If this
breaks your code -- as if there's any code based on comefrom --
You may retain the original behaviour by assigning a true value
to `$Acme::ComeFrom::CacheEXPR'.

=item comefrom &NAME

The `comefrom-&NAME' form is quite different from the other forms of
`comefrom'.  In fact, it isn't a comefrom in the normal sense at all,
and doesn't have the stigma associated with other `comefrom's.  Instead,
it installs a post-processing handler for the subroutine, and a jump
would be made just *after* the subroutine's execution.

=back

If two or more `comefrom' were applied to the same LABEL, EXPR or NAME,
they will be executed simultaneously via `fork()'.  The forking are
ordered by their occurrances, with the parent process receiving
the last one.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
