%define module_name Acme-Devel-Hide-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Hide a perl module for testing, in one statement
Group: Development/Perl
License: apache
URL: https://github.com/dagolden/Acme-Devel-Hide-Tiny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAGOLDEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The the Devel::Hide manpage and the Test::Without::Module manpage modules are very helpful
development tools.  Unfortunately, using them in your .t files adds a
test dependency.  Maybe you don't want to do that.

Instead, you can use the one-liner from the SYNOPSIS above, which is an
extremely stripped down version of the Devel::Hide manpage. NOTE: this method
only works on Perl v5.8.1 and later.

Here is a more verbose, commented version of it:

    # 'lib' adds its arguments to the front of @INC
    use lib

        # add one coderef per path to hide
        map {
            # create lexicals for module and fake module code; fake module
            # code dies with the error message we want
            my ( $m, $c ) = ( $_, qq{die "Can't locate $_ (hidden)\n"} );

            # construct and return a closure that provides the fake module
            # code only for the module path to hide
            sub {

                # return if not the path to hide; perl checks rest of @INC
                return unless $_[1] eq $m;

                # return a file handle to the fake module code
                open my $fh, "<", \$c; return $fh
            }
        }
        
        # input to map is a list module names, converted to paths;
        qw{Cpanel/JSON/XS.pm JSON/XS.pm}

    ; # end of 'use lib' statement

When perl sees a coderef in `@INC', it gives the coderef a chance to
provide the source code of that module.  In this case, if the path is the
one we want to hide, it returns a handle to source code that dies with the
message we want and perl won't continue looking at @<INC> to find the real
module source.  The module is hidden and dies with a message similar to the
one that would happen if it weren't installed.

=for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
