%define module_name Acme-Evil
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003002
Release: alt1
Summary: RFC 3514 (evil bit) implementation for Perl modules
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
RFC3514 introduces a new flag
called the "evil bit" in all IP packets. The intention is to simplify
the work of firewalls. Software that sends IP packets with malicious
intent must set the evil bit to true, and firewalls can simply drop
such packets.

The evil pragma is a Perl implementation of the same concept. With
this pragma malicious modules can declare their evil intent while
critical modules can request that they will only use / run alongside
non-evil code.

The pragma can be used in the following ways:

=over

=item use evil;

Marks the current package as evil. All malicious modules MUST use this
directive to ensure the full functionality of this module.

=item no evil ':strict';

The calling module function properly if malignant code is loaded
anywhere in the program. Throws an exception if an evil module is
loaded, whether at the moment of calling this pragma or in the future.

=item no evil ':intermediate'; (TODO)

Not yet implemented. The calling module cannot function properly if it
is using evil code, whether directly or indirectly. Throws an
exception if an evil module is loaded by the calling module or by one
of the children modules (or by one of their children modules, etc).

=item no evil ':lax'; (TODO)

Not yet implemented. The calling module cannot function properly if it
is using evil code direcly. Throws an exception if the calling module
loads an evil module.

=item no evil;

This would normally be equivalent to `no evil ':intermediate';' but
since that mode is not yet implemented this call does the same as
`no evil ':strict';' while also emitting a warning saying that this
behaviour will change in a future version.

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/e*
%perl_vendor_privlib/A*

%changelog
