%define module_version 0.02
%define module_name Acme-FixIO
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Workaround for Windows chcp 65001 UTF-8 output bug
Group: Development/Perl
License: perl
URL: https://github.com/klaus03/Acme-FixIO

Source0: http://cpan.org.ua/authors/id/K/KE/KEICHNER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This is the underlying problem:
The last octet is repeated when Perl outputs a UTF-8 encoded string in
cmd.exe, chcp 65001

Two StackOverflow articles with basically the same problem:
http://stackoverflow.com/questions/23416075 and
http://stackoverflow.com/questions/25585248.

This is caused by a bug in Windows. When writing to a console set to code
page 65001, WriteFile() returns the number of characters written instead
of the number of bytes.

Workaround: Inject a binmode(STDOUT, ':unix:encoding(utf8):crlf') into the
perl program.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/A*

%changelog
