%define module_name Acme-Lvalue
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Math/Trig.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel

Name: perl-%module_name
Version: 0.03
Release: alt2
Summary: Generalized lvalue subroutines
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAUKE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module makes a number of perl builtins return lvalues, letting you assign
to them. This lets you do things like:

  reverse(hex $x) = '9558295373';
  # $x eq 'deadbeef'
  #   because hex 'deadbeef' == 3735928559
  #   and reverse '3735928559' eq '9558295373'

When you load this module, you can pass a list of 0 or more import
specifications. If you don't pass any, nothing is exported. Every import
specification must be one of the following:

=over

=item * The string `:builtins'. 

This overrides the following builtins:

`chr',
`cos',
`defined',
`exp',
`hex',
`length',
`log',
`oct',
`ord',
`quotemeta',
`reverse',
`sin',
`sqrt'.

=item * Any of the builtins listed above.

This lets you pick and choose which builtins to override.

=item * An array reference of the form [*NAME*, *CODEREF_1*, *CODEREF_2*].

This lets you create customized invertible lvalue functions. *NAME* is the
name of the function that should be generated, *CODEREF_1* is the
implementation that should be called by the function, and *CODEREF_2* is the
inverse operation that should be called when the result is assigned to.

That is, after `use Acme::Lvalue ['foo', $REF_1, $REF_2]', using `foo($x)' as
normal is equivalent to `$REF_1->($x)' while using `foo($x) = $y' is
equivalent to `$x = $REF_2->($y)'.

Example:

  use Acme::Lvalue ['succ', sub { $_[0] + 1 }, sub { $_[0] - 1 }];

  my $x = succ 4;  # $x == 5
  succ($x) = 43;   # $x == 42

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
