# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DateTime.pm) perl(DateTime/Event/Recurrence.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.20
%define module_name Acme-PM-Frankfurt-Meetings
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.20
Release: alt1
Summary: Get the next date(s) of the Frankfurt PM meeting 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TO/TOMFAHLE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use strict;

    use warnings;

    use Acme::PM::Frankfurt::Meetings qw/next_meeting/;

    print "Next Frankfurt.pm meeting: ", next_meeting(1) , "\n";

    print "Next 3 Frankfurt.pm meetings:\n";

    print join("\n", next_meeting(3) ), "\n";

    # $dt is a DateTime Object
    my $dt = next_meeting;

    my $ymd = $dt->ymd('/');
    print "$ymd\n";

    my $hms  = $dt->hms; 
    print "$hms\n";



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/A*

%changelog
