%define module_name Activiti-Rest-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Util.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Software/License.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Throwable/Error.pm) perl(URI/Escape.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1259
Release: alt1
Summary: Client api for the rest api of Activiti
Group: Development/Perl
License: perl
URL: https://github.com/Universiteitsbibliotheek/Activiti-Rest-Client

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NJ/NJFRANCK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
my $client = Activiti::Rest::Client->new(
    url => 'http://kermit:kermit@localhost:8080/activiti-rest/service'
  );

  my $res = $client->process_definitions;

  die("no parsed content") unless $res->has_parsed_content;

  my $pdefs = $res->parsed_content;

  my @ids = map { $_->{id} } @{ $pdefs->{data} };
  for my $id(@ids){
    print Dumper($client->process_definition(processDefinitionId => $id)->parsed_content);
  }


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/A*

%changelog
