%define module_name Algorithm-BIT-XS
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(ExtUtils/MakeMaker.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt5
Summary: Binary indexed trees / Fenwick trees
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz

%description
A binary indexed tree is a data structure similar to an array of integers.
The two main operations are updating an element and calculating a
prefix sum, both of which run in time logarithmic in the size of the tree.

=over

=item Algorithm::BIT::XS->new(*$len*)

Create a new binary indexed tree of length *$len*. As binary indexed
trees are 1-indexed, its indexes are [1..*$len*]. It is initially
filled with zeroes.

=item $bit->clear()

Clears the binary indexed tree (sets all elements to 0).

=item $bit->query(*$idx*)

Returns the prefix sum *$bit*[1] + *$bit*[2] + ... + *$bit*[*$idx*].

=item $bit->update(*$idx*, *$value*)

Adds *$value* to *$bit*[*$idx*].

=item $bit->get(*$idx*)

Returns the value of *$bit*[*$idx*].

=item $bit->set(*$idx*, *$value*)

Sets *$bit*[*$idx*] to *$value*.

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
