Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Algorithm-CurveFit
Version:        1.05
Release:        alt1_18
Summary:        Nonlinear Least Squares Curve Fitting
License:        GPL+ or Artistic
URL:            http://search.cpan.org/dist/Algorithm-CurveFit/
Source0:        http://www.cpan.org/authors/id/S/SM/SMUELLER/Algorithm-CurveFit-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Math/MatrixReal.pm)
BuildRequires:  perl(Math/Symbolic.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(warnings.pm)
Requires:       perl(Math/Symbolic.pm) >= 0.602
%filter_from_requires /^perl\\(Math.Symbolic.pm\\)$/d



%description
Algorithm::CurveFit implements a nonlinear least squares curve fitting
algorithm. That means, it fits a curve of known form (sine-like,
exponential, polynomial of degree n, etc.) to a given set of data points.

%prep
%setup -q -n Algorithm-CurveFit-%{version}
chmod a-x lib/Algorithm/CurveFit.pm

%build
perl Build.PL --install_path bindoc=%_man1dir installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
