# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/CurveFit.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/PP.pm) perl(Test/Most.pm) perl(Time/HiRes.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Algorithm-CurveFit-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Convenience wrapper around Algorithm::CurveFit
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TT/TTKCIAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a convenience wrapper around the Algorithm::CurveFit manpage.  Given a body of (x, y) data points, it will generate a polynomial formula f(x) = y which fits that data.

Its main differences from the Algorithm::CurveFit manpage are:

=over 4

=item * It synthesizes the initial formula for you,

=item * It allows for a time limit on the curve-fit instead of an iteration count,

=item * It implements the formula as source code (or as a perl coderef, if you want to use the formula immediately in your program).

=back

Additionally it returns a maximum deviation and average deviation of the formula vs the xydata, which is more useful (to me, at least) than the Algorithm::CurveFit manpage's square residual output.  Closer to 1.0 indicates a better fit.  Play with `terms => #' until these deviations are as close to 1.0 as possible, and beware overfitting.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
