# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Diff.pm) perl(Algorithm/Diff/XS.pm) perl(Exporter.pm) perl(Module/Build.pm) perl(Test.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Without/Module.pm)
# END SourceDeps(oneline)
%define module_version 1.001
%define module_name Algorithm-Diff-Any
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.001
Release: alt1
Summary: Perl module to find differences between files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JA/JAWNSY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a simple module to select the best available implementation of the.standard `diff' algorithm, which works by effectively trying to solve the
Longest Common Subsequence (LCS) problem. This algorithm is described in:
*A Fast Algorithm for Computing Longest Common Subsequences*, CACM, vol.20,
no.5, pp.350-353, May 1977.

However, it is algorithmically rather complicated to solve the LCS problem;
for arbitrary sequences, it is an NP-hard problem. Simply comparing two
strings together of lengths *n* and *m* is O(n x m). Consequently, this
means the algorithm necessarily has some tight loops, which, for a dynamic
language like Perl, can be slow.

In order to speed up processing, a fast (C/XS-based) implementation of the
algorithm's core loop was implemented. It can confer a noticable performance
advantage (benchmarks show a 54x speedup for the `compact_diff' routine).


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
