# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Module/Build.pm) perl(Object/Pad.pm) perl(Test2/V0.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define module_name Algorithm-Gutter
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: cellular automata to simulate rain in a gutter
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JM/JMATES/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module models a rain gutter, composed of discrete cells, where some
cells have holes in them, of some threshold value, that when the
threshold is reached the fluid will drain from that cell, triggering a
piece of code supplied by the caller. Other methods are provided to
simulate rain (up to the caller) and to redistribute the fluid between
adjacent cells (with a slow and simple algorithm).

Productive uses (dubious--discuss) include procedural generation, in
particular music composition where one may want rhythmic effects similar
to water accumulating and then dripping out of a rain gutter.

The cells are held in an array reference (the gutter); the caller may
need to fiddle around with the cells directly simulate various effects.

Various methods may throw errors, for example if a cell lacks an update
callback function. Such callbacks are not mandatory to give the caller
flexibility in wiring up the gutter in fancy ways.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
