%define module_name Algorithm-MinPerfHashTwoLevel
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Config.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Copy.pm) perl(Test/More.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt2
Summary: construct a "two level" minimal perfect hash
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Y/YV/YVES/%{module_name}-%{version}.tar.gz

%description
This module implements an algorithm to construct (relatively efficiently) a
minimal perfect hash using the "two level" algorithm. A perfect hash is one
which has no collisions for any keys, a minimal perfect hash has exactly the
same number of buckets as it has keys. The "two level" algorithm involves
computing two hash values for each key. The first is used as an initial lookup
into the bucket array to find a mask value which is used to modify the second
hash value to determine the actual bucket to read from. This module computes
the appropriate mask values.

In this implementation only one 64 bit hash value is computed, but the high
and low 32 bits are used as if there were two hash values. The hash function
used is stadtxhash. (The full 64 bit hash is called h0, the high 32 bits are
called h1, and the low 32 bits are called h2.)

Computing the hash and mask is done in C (via XS).

The process for looking up a value in a two level hash with n buckets is
as follows:

    0. compute the h0 for the key. (h1 = h0 >> 32; h2 = h0 & 0xFFFFFFFF;)
    1. compute idx = h1 %% n;
    2. find the xor_val for bucket[idx]
    3. if the xor_val is zero we are done, the key is not in the hash
    4. compute idx 
        if variant == 0 or (int)xor_val > 0
         idx = (h2 ^ xor_val) %% n;
        else
         idx = -xor_val-1
    5. compare the key data associated with bucket[idx] with the key provided
    6. if they match return the desired value.

This module performs the task of computing the xor_val for each bucket.

*NOTE* in Perl a given string may have differing binary representations
if it is encoded as utf8 or not. This module uses the same conventions
as Perl itself, which is that keys are stored in their minimal form when
possible, and are only stored in their unicode (utf8) form when they
cannot be downgraded to latin-1. This ensures that the unicode and latin-1
representations of a given string are treated as the same key. This module
deals with this by "normalizing" the keys and values into latin-1, but
t...

%prep
%setup -q -n %{module_name}-%{version}

[ %version = 0.16 ] && rm -f t/Corruption.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/T*
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
