%define module_version 0.13
%define module_name Algorithm-SAT-Backtracking
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Hash/Ordered.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Storable.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: A simple Backtracking SAT solver written in pure Perl
Group: Development/Perl
License: perl
URL: https://github.com/mudler/Algorithm-Sat-Backtracking

Source0: http://cpan.org.ua/authors/id/M/MU/MUDLER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Algorithm::SAT::Backtracking is a pure Perl implementation of a simple SAT Backtracking solver.

In computer science, the Boolean Satisfiability Problem (sometimes called Propositional Satisfiability Problem and abbreviated as *SATISFIABILITY* or *SAT*) is the problem of determining if there exists an interpretation that satisfies a given Boolean formula. In other words, it asks whether the variables of a given Boolean formula can be consistently replaced by the values TRUE or FALSE in such a way that the formula evaluates to TRUE.

If this is the case, the formula is called satisfiable. On the other hand, if no such assignment exists, the function expressed by the formula is identically FALSE for all possible variable assignments and the formula is unsatisfiable.

For example, the formula "a AND NOT b" is satisfiable because one can find the values a = TRUE and b = FALSE, which make (a AND NOT b) = TRUE. In contrast, "a AND NOT a" is unsatisfiable. More: https://en.wikipedia.org/wiki/Boolean_satisfiability_problem .

Look also at the test file for an example of usage.

the Algorithm::SAT::Expression manpage use this module to solve Boolean expressions.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/A*

%changelog
