# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(Encode.pm) perl(HTTP/Daemon.pm) perl(HTTP/Status.pm) perl(JSON.pm) perl(Pod/POM.pm) perl(Pod/POM/View/HTML.pm) perl(Pod/Simple/Wiki.pm) perl(Pod/Simple/Wiki/Googlecode.pm) perl(URI/Escape.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Alien-GvaScript
%define upstream_version 1.45

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Gva extension to the prototype javascript framework
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Alien/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
GvaScript (pronounce "gee-vascript") is a javascript framework born in
Geneva, Switzerland (GVA is the IATA code for Geneva Cointrin
International Airport).

It is built on top of the prototype object-oriented javascript framework
(http://prototype.conio.net) and offers a number of extensions and
widgets, such as keymap handling, application-specific events,
autocompletion on input field, tree navigation, and forms with autofocus
and repeated sections. These functionalities are described in separate
documentation pages (see Alien::GvaScript::Intro).

GvaScript is distributed using Perl tools, but the actual content of the
library is pure javascript; hence its location in the Alien namespace
(see the Alien manifesto).

GvaScript runtime library does not need Perl; you can integrate it in
any other Web programming framework. Perl is only needed for developers
who want to modify GvaScript sources and recreate a distribution
package.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%check
./Build test

%install
./Build install --destdir %buildroot

%files
%doc Changes META.json META.yml  README
%perl_vendor_privlib/*


%changelog
