%define module_name Alien-Role-Dino
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/cmake /usr/bin/pod2man gcc-c++ perl(Alien/Base.pm) perl(Alien/Build.pm) perl(Alien/Build/Plugin.pm) perl(Class/Method/Modifiers.pm) perl(ExtUtils/MakeMaker.pm) perl(FFI/CheckLib.pm) perl(Path/Tiny.pm) perl(Role/Tiny.pm) perl(Test/Alien.pm) perl(Test/Alien/Build.pm) perl(Test2/Mock.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Experimental support for dynamic share Alien install
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Alien::Role::Dino

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Every now and then someone will ask me why thus and such the Alien manpage thing 
doesn't work with a dynamic library error.  My usual response is can you 
make it work with static libraries?  The reason for this is that 
building dynamic libraries for an the Alien manpage share install introduce 
a number of challenges, and honestly I don't see the point of using 
them, if you can avoid it.  So far I haven't actually seen a situation 
where it couldn't be avoided.  Just to be clear: dynamic libraries are 
fine for Alien, and in fact desirable when you are using the system 
provided libraries.  You get the patches and security fixes supplied by 
your operating system.

Okay, so why not build a dynamic library for a share install?

For this discussion, say you have an alienized library `Alien::libfoo' 
and an XS module that uses it called `Foo::XS' (as illustrated in the 
synopsis above).

=over 4

=item Your Alien becomes a run-time dependency.

When you link your `Foo::XS' module with a static library from 
`Alien::libfoo' it gets added into the DLL or `.so' file that the Perl 
toolchain produces.  That means when you later use it, it doesn't need 
anything else.  When you try to do the same thing with a dynamic 
library, you need that dynamic library, which is stored in a share 
directory of `Alien::libfoo'.

For people who install out of CPAN this is probably not a big deal, but 
for operating system vendors (the people who integrate Perl modules into 
their operating system), it is a hassle because now you need this big 
build tool the Alien::Build manpage and the alien `Alien::libfoo' with extra 
dependencies during runtime.  Normally you wouldn't need those packages 
installed for end-user use.

=item Upgrades can and will break your XS module.

Again, when `Alien::libfoo' builds a static library and it gets linked 
into a DLL or `.so' for `Foo::XS', it doesn't need the original 
library anymore.  If you are using a dynamic library and you do the same 
thing it maybe works today, but say tomorrow yo...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc author.yml LICENSE Changes README
%perl_vendor_privlib/A*

%changelog
