%filter_from_provides '/^perl\([^A]/d'
%filter_from_requires /^perl.Crypt.RSA.Primitives.pm./d
%filter_from_requires /^perl.Crypt.RSA.Key.Public.pm./d
%filter_from_requires /^perl.Crypt.RSA.Key.Private.pm./d
%filter_from_requires /^perl.Crypt.RSA.Key.pm./d
%filter_from_requires /^perl.Crypt.RSA.Errorhandler.pm./d
%filter_from_requires /^perl.Crypt.RSA.Debug.pm./d
%filter_from_requires /^perl.Crypt.RSA.DataFormat.pm./d
%define module_name Alt-Crypt-RSA-BigInt
# BEGIN SourceDeps(oneline):
BuildRequires: libgmp-devel pari-devel perl(Benchmark.pm) perl(Carp.pm) perl(Class/Loader.pm) perl(Convert/ASCII/Armour.pm) perl(Crypt/Blowfish.pm) perl(Crypt/CBC.pm) perl(Crypt/RIPEMD160.pm) perl(Data/Buffer.pm) perl(Data/Dumper.pm) perl(Devel/CheckLib.pm) perl(Digest/MD2.pm) perl(Digest/MD5.pm) perl(Digest/SHA.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Math/BigInt.pm) perl(Math/BigInt/GMP.pm) perl(Math/Prime/Util.pm) perl(Math/Prime/Util/GMP.pm) perl(Sort/Versions.pm) perl(Test/More.pm) perl(Tie/EncryptedHash.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt2
Summary: RSA public-key cryptosystem, using Math::BigInt
Group: Development/Perl
License: perl
URL: https://github.com/danaj/Alt-Crypt-RSA-BigInt

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DANAJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a modification of the Crypt::RSA module to remove all use and
dependencies on Pari and Math::Pari.

This first version is intended to be a plug-in replacement for Crypt::RSA,
with no user-visible changes.  This means some issues will remain
unresolved until future versions.

Math::Pari is completely removed.  This includes the two modules:

   - Crypt::Primes   =>   Math::Prime::Util
   - Crypt::Random   =>   Bytes::Random::Secure

All operations are now performed using Math::BigInt, and prefer the
GMP and Pari backends.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes.old TODO Changes README LICENSE
%perl_vendor_privlib/A*
%perl_vendor_privlib/C*

%changelog
