# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl(Pod/Usage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    AnnoCPAN-Perldoc-SyncDB
%define upstream_version 0.11

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_11

Summary:    Download the AnnoCPAN database
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/AnnoCPAN/%{upstream_name}-%{upstream_version}.tgz

BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(Test/More.pm)

BuildArch: noarch
Source44: import.info


%description
This module provides a simple interface to mirror the the
http://annocpan.org/ manpage content to a local machine. In conjunction
with the the AnnoCPAN::Perldoc manpage module, this allows one to get all
the benefits of the AnnoCPAN website in one's local 'perldoc' command.

Recommended usage: 1) Install this module and AnnoCPAN::Perldoc, 2) set up
a weekly process to run the 'syncannopod' command included in this
distribution, 3) Put the following in your shell configuration: 'alias
perldoc annopod'.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc ChangeLog LICENSE README
%{_mandir}/man1/*
%perl_vendor_privlib/*
/usr/bin/syncannopod

%changelog
