%define module_name AnyEvent-FDpasser
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(Errno.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Socket.pm) perl(Time/HiRes.pm) perl(XSLoader.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.0
Release: alt9
Summary: pass file descriptors between processes using non-blocking buffers
Group: Development/Perl
License: see COPYING
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FR/FRACTAL/%{module_name}-%{version}.tar.gz

%description
This module provides an object oriented interface for passing filehandles between processes. Its primary goals are API simplicity, portability, and reliability. It is suitable for use in non-blocking programs where blocking in even exceptional circumstances is undesirable. Finally, this module should be efficient enough for nearly all use-cases.

This module currently works on BSD4.4-like systems (*BSD, Linux, Mac OS X) where it uses the `SCM_RIGHTS' ancillary data feature over `AF_UNIX' sockets, on BSD4.3-like systems (Solaris, IRIX?) where it uses `msg_accrights' field of `msghdr' over `AF_UNIX' sockets, and on SysV-like systems (Solaris, HP-UX, AIX?) where it uses the `ioctl(I_SENDFD/I_RECVFD)' feature of STREAMS pipes.

Note that a passer object is "bidrectional" and you can use the same object to both send and receive filehandles (each side has a separate input and output buffer).

After sending a filehandle, the sending process will automatically destroy it and you shouldn't close it yourself. Forgetting all references to it is what you should do so that the underlying descriptor is actually closed after it is sent. The exception to this is when you also wish to keep the handle in the sender. Usually you will only do this for sockets that you `accept()' from.



=over 4

=item my $passer = AnyEvent::FDpasser->new([ fh => <handle(s)>,][ dont_set_nonblocking => 1,][ on_error => $cb->(),])

    ## Both of these are the same
    my $passer = AnyEvent::FDpasser->new;
    my $passer = AnyEvent::FDpasser->new( fh => [ AnyEvent::FDpasser::fdpasser_socketpair ] );

    ## Make sure filehandles are AF_UNIX sockets (BSD) or STREAMS pipes (SysV)
    my $passer = AnyEvent::FDpasser->new( fh => [$fh1, $fh2] );

    ## No i_am_parent or i_am_child required in this case:
    my $passer = AnyEvent::FDpasser->new( fh => $fh, );

When creating a passer objects with two filehandles, it is assumed you want to fork. After you fork you are then supposed call `$passer->i_am_parent' and `$passer->i_am_child'. Creating a pas...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING README README.pod
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
