# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent/HTTPD.pm) perl(AnyEvent/HTTPD/SendMultiHeaderPatch.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.1.0
%define module_name AnyEvent-HTTPD-CookiePatch
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: Patch of AnyEvent::HTTPD for cookie support
Group: Development/Perl
License: Artistic_2_0
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CI/CINDY/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
# by module injection
    use AnyEvent::HTTPD::CookiePatch qw(inject);

    # or by inheritance
    use AnyEvent::HTTPD::CookiePatch;
    my $httpd = AnyEvent::HTTPD->new( request_class => 'AnyEvent::HTTPD::CookiePatch' );

    # and then in your handler
    sub {
        my($httpd, $req) = @_;

        # get cookie
        my $cookie_a = $req->cookie('a');

        # set cookie
        $req->cookie('a', 'a_value');
        # or with other cookie parameters
        $req->cookie('b', 'b_value', 10*60, '/', '.example.com');

        # then add the cookie header when respond
        $req->respond(200, 'OK', {
            ...
            'set-cookie' => $req->{_set_cookie},
            ...
        }, "html...");
    }
%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
