%define module_name AnyEvent-MPV
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/PP.pm) perl(JSON/XS.pm) perl(Task/Weaken.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: remote control mpv (https://mpv.io)
Group: Development/Perl
License: see COPYING
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLEHMANN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to remote control mpv (a video player). It also
is an the AnyEvent manpage user, you need to make sure that you use and run a
supported event loop.

There are other modules doing this, and I haven't looked much at them
other than to decide that they don't handle encodings correctly, and since
none of them use AnyEvent, I wrote my own. When in doubt, have a look at
them, too.

Knowledge of the mpv command interface is required to
use this module.

Features of this module are:

=over

=item uses AnyEvent, so integrates well into most event-based programs

=item supports asynchronous and synchronous operation

=item allows you to properly pass binary filenames

=item accepts data encoded in any way (does not crash when mpv replies with non UTF-8 data)

=item features a simple keybind/event system

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes README
%perl_vendor_privlib/A*

%changelog
