# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(IO/Select.pm) perl(List/Util.pm) perl(Scalar/Util.pm) perl(base.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    AnyEvent-Task
%define upstream_version 0.805

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2
Summary:    Client/server-based asynchronous worker pool
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/AnyEvent/%{upstream_name}-%{upstream_version}.tar.gz
BuildRequires: perl(AnyEvent.pm)
BuildRequires: perl(Callback/Frame.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Guard.pm)
BuildRequires: perl(JSON/XS.pm)
BuildRequires: perl(Log/Defer.pm)
BuildRequires: perl(common/sense.pm)
BuildArch:  noarch
Source44: import.info

%description
*WARNING:* This module's API may change without warning. Also, the docs are
somewhat incomplete and out of date. I will be fixing this soonish.

The synopsis makes this module sounds much more complicated than it
actually is. the AnyEvent::Task manpage is a fork-on-demand but
persistent-worker server (the AnyEvent::Task::Server manpage) combined with
an asynchronous interface to a request queue and pooled-worker client (the
AnyEvent::Task::Client manpage). Both client and server are of course built
with the AnyEvent manpage because it's awesome. However, workers can't use
AnyEvent (yet).

A server is started with 'AnyEvent::Task::Server->new'. This should at
least be passed the 'listen' and 'interface' arguments. Keep the returned
server object around for as long as you want the server to be running.
'interface' is the code that should handle each request. See the interface
section below for its specification. A 'setup' coderef can be passed in to
run some code when a new worker is forked. A 'checkout_done' coderef can be
passed in to run some code whenever a checkout is released (see below).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLMAN1DIR=%_man1dir INSTALLDIRS=vendor
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc COPYING Changes META.json META.yml  README
%perl_vendor_privlib/*


%changelog
