%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent/HTTP.pm) perl(Digest/HMAC_SHA1.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Net/SSLeay.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(URI/Escape.pm) perl(UUID/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.9.3
%define module_name AnyEvent-Yubico
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9.3
Release: alt1
Summary: AnyEvent based Perl extension for validating YubiKey OTPs.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAIN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Validates a YubiKey OTP (One Time Password) using the YKVAL 2.0 protocol as 
defined here: https://github.com/Yubico/yubikey-val/wiki/ValidationProtocolV20

To use this module, an API key is required, which can be requested here:
https://upgrade.yubico.com/getapikey/

When creating the AnyEvent::Yubico instance, the following arguments can be passed:

=over 4

=item client_id = $id_int

Required. The client ID corresponding to the API key.

=item api_key => $api_key_string

Optional. The API key used to sign requests and verify responses. Without 
this response signatures won't be verified.

=item urls => $array_of_urls

Optional. Defines which validation server URLs to query. The default uses 
the public YubiCloud validation servers. Must support version 2.0 of the 
validation protocol.

Example:

  $yk = AnyEvent::Yubico->new({
      client_id => ...,
      api_key => ...,
      urls => [
          "http://example.com/wsapi/2.0/verify",
          "http://127.0.0.1/wsapi/2.0/verify"
      ]
  });

=item sign_requests => $enable

Optional. When enabled (enabled by default) requests will be signed, as long 
as api_key is also provided.

=item timeout => $seconds

Optional. Timeout parameter sent to the server, see the protocol details for 
more information.

=item sl => $level

Optional. Security level parameter sent to the server, see the protocol 
details for more information.

=item timestamp => $enable

Optional. When enabled, sends the timestamp parameter to the server, causing
YubiKey counter and timestamp information to be returned in the response.

=item local_timeout => $seconds

Optional. Sets the local timeout for how long the verify method will wait 
until failing. The default is 30 seconds.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README COPYING
%perl_vendor_privlib/A*

%changelog
