# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 Apache-SessionX
%define upstream_version 2.01

Name:		perl-%{upstream_name}
Version:	%{upstream_version}
Release:	alt1_13

Summary:	An extended persistence framework for session data
License:	GPL+ or Artistic
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/authors/id/G/GR/GRICHTER/%{upstream_name}-%{upstream_version}.tar.bz2
Patch0:		%{name}-2.01.fhs.patch
Patch1:		%{name}-2.01.test.patch


BuildRequires:	perl(Apache/Session.pm)
BuildRequires:  perl(DB_File.pm)
BuildArch:	noarch


%define testdir %{_tmppath}/%{name}-%{version}-test
Source44: import.info

%description
Apache::SessionX extends Apache::Session. It was initially written to use
Apache::Session from inside of HTML::Embperl, but is seems to be useful
outside of Embperl as well, so here is it as standalone module.

Apache::Session is a persistence framework which is particularly
useful for tracking session data between httpd requests. Apache::Session is
designed to work with Apache and mod_perl, but it should work under CGI and
other web servers, and it also works outside of a web server altogether.

Apache::Session consists of five components: the interface, the object
store, the lock manager, the ID generator, and the serializer. The interface
is defined in SessionX.pm, which is meant to be easily subclassed. The
object store can be the filesystem, a Berkeley DB, a MySQL DB, an Oracle DB,
or a Postgres DB. Locking is done by lock files, semaphores, or the locking
capabilities of MySQL and Postgres. Serialization is done via Storable, and
optionally ASCII-fied via MIME or pack(). ID numbers are generated via MD5.
The reader is encouraged to extend these capabilities to meet his own
requirements.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
chmod 644 README
%patch0 
%patch1  -p 1

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor < /dev/null
%make_build

%check
%{__rm} -rf %{testdir}
mkdir %{testdir}
export TESTDIR=%{testdir}
%{__make} test

%install
%makeinstall_std
install -d -m 755 %{buildroot}%{_localstatedir}/lib/ApacheSessionX

%files
%doc CHANGES README
%{perl_vendor_privlib}/Apache
%attr(-,apache,apache) %{_localstatedir}/lib/ApacheSessionX


%changelog
