# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cache/Memcached/Fast.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Uncompress/Gunzip.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Plack/Builder.pm) perl(Redis.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name App-CPAN-MetaDB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Provide CPAN metadata for cpanminus clients
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SQ/SQUEEK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a the Plack manpage application that grabs CPAN metadata and serves it to.the cpanminus manpage clients. You can serve cpanminus clients by creating a `app.psgi' 
application:

    #!/usr/bin/env plackup

    use strict;
    use warnings;

    use Plack::Builder;

    use App::CPAN::MetaDB;
    use App::CPAN::MetaDB::Memcached;

    my $metadb = App::CPAN::MetaDB->new(
        mirror  => 'http://cpan.cpantesters.org', # use the most suitable (fast) mirror
        storage => App::CPAN::MetaDB::Memcached->new({
            servers => ['127.0.0.1:11211']
        })
    );

    builder {
        mount "/" => $metadb->app;
    }



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
