%define module_name App-Cpanx
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: A CPAN downloader script
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JA/JACOBG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This program will download, display, and install modules (and their
dependencies) from CPAN. A public repository of user contributed
perl code.

This script is different to scripts like cpan and cpanm in that it
will show what it will do before it does anything. This is important
when a module has a lot of dependencies.

Just run something like "cpanx Module", it will download what it
needs, then display the dependencies in the order that they will
need to be installed to install the module.

Use the -i option, it will just show the information, and not ask
if you actually want to install it.

Use the -n option to set the script to not be interactive. It will
install without asking first.

Use the -S option to disable sudo during "make install".

If the module is up to date, you can use the -r option to reinstall.

If the tests aren't passing and you want to install anyway, use the
-T option.

Use the -d option to only install the dependencies, not the module
itself.

Use the -l option to open a shell in the module's directory and
then you can look around.

Use the -p option to open perldoc for the module.

The -f option can be used to display what files will be installed.
Use along with the -I, -L, -B, -SC, -M1, -M3 or the PERL_MM_OPT or
PERL_MB_OPT environment variables, to make sure you set the right
settings before you install.

You can uninstall the module with -u. It will show you what files
will be removed before actually removing them.

Set the CPAN mirror with the -m option. By default it uses
http://www.cpan.org.

Find the best CPAN mirror by running the command with -M. It will
ping all CPAN mirrors and show you the 10 servers with the best
time and let you choose which one you want.

Modules are cached and reused between calls, so you can look at the contents of the module in a shell, then get info about the install, then install the module and the module only downloads from cpan once. The cache is stored in ~/.cpanx.

This script has no dependencies. It uses the curl program to download.

Thi...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*
%_man1dir/*
%_bindir/*

%changelog
