%define module_name App-Env
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Digest.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(File/Which.pm) perl(Getopt/Long.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(IPC/System/Simple.pm) perl(JSON/PP.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Module/Find.pm) perl(Params/Validate.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Shell/Config/Generate.pm) perl(Shell/GetEnv.pm) perl(Shell/Guess.pm) perl(Storable.pm) perl(Test/Lib.pm) perl(Test/More.pm) perl(Test/Script.pm) perl(Test2/API.pm) perl(Test2/V0.pm) perl(constant.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: manage application specific environments
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
App::Env presents a uniform interface to initializing environments
for applications which require special environments.  App::Env only
handles the loading, merging, and caching of environments; it does not
create them.  That is done within modules for each application suite
(e.g. App::Env::MyApp).  App::Env ships with two such modules,
App::Env::Null which simply returns a snapshot of the current
environment, and App::Env::Example, which provides example code for
creating an application specific environment.

App::Env is probably most useful in situations where a Perl program
must invoke multiple applications each of which may require an
environment different and possibly incompatible from the others.  The
simplified interface it provides makes it useful even in less
complicated situations.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README.mkdn Changes LICENSE README CONTRIBUTING.md
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
