%define module_version 1.1.1
%define module_name App-GitHooks-Plugin-BlockNOCOMMIT
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/GitHooks.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Validate/Type.pm) perl(File/Slurp.pm) perl(Git/Repository.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Test/Requires/Git.pm) perl(Test/Type.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.1
Release: alt1
Summary: Prevent committing code with #NOCOMMIT mentions.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/App-GitHooks-Plugin-BlockNOCOMMIT

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
Sometimes you want to experiment with code, but you want to make sure that test
code doesn't get committed by accident.

This plugin allows you to use `#NOCOMMIT' to indicate such code blocks, and
will prevent you from committing those blocks.

For example:

_# This is a test that will not work once deployed.
_# NOCOMMIT
_...

Note that the following variations on the tag are correctly picked up:

=over 4

=item * `#NOCOMMIT'

=item * `# NOCOMMIT'

=item * `# NO COMMIT'

=back
%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes example
%perl_vendor_privlib/A*

%changelog
