%define module_version 1.1.3
%define module_name App-GitHooks-Plugin-ForceBranchNamePattern
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/GitHooks.pm) perl(Capture/Tiny.pm) perl(Log/Any.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/Git.pm) perl(Test/More.pm) perl(Test/Requires/Git.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.3
Release: alt1
Summary: Require branch names to match a given pattern before they can be pushed to the origin.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/App-GitHooks-Plugin-ForceBranchNamePattern

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
For example, if you define in your .githooksrc file the following:

_[ForceBranchNamePattern]
_branch_name_pattern = /^[a-zA-Z0-9]+$/

Then a branch named `TestBranch' can be pushed to the origin, but not one
named `test_branch'.

A practical use of this plugin is making Puppet environment out of git
branches, since Puppet environment names must be strictly alphanumeric.
%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md example
%perl_vendor_privlib/A*

%changelog
