# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Greple.pm) perl(Getopt/EX/Numbers.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name App-Greple-L
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Greple module to produce result by line numbers
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/greple-L

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to use line numbers to specify patterns or
regions which can be used in greple options.

=over 7

=item -ML *line numbers*

If a line number argument immediately follows -ML module option, it
is recognized as a line number.  Note that, this format implicitly
adds the `--cm N' option to disable the coloring feature.  Use the
`--cm @' option to cancel it.

Next command will show 42nd line.

    greple -ML 42 file

Multiple lines can be specified by joining with comma:

    greple -ML 42,52,62

Range can be specified by colon:

    greple -ML 42:84

You can also specify the step with range.  Next command will print
all even lines from line 10 to 20:

    greple -ML 10:20:2

Any of them can be omitted.  Next commands print all, odd and even
lines.

    greple -ML ::    # all lines
    greple -ML ::2   # odd lines
    greple -ML 2::2  # even lines

If start and end number is negative, they are subtracted from the
maxmum line number.  If the end number is prefixed by plus (`+') sign,
it is summed with start number.  Next commands print top and last 10
lines respectively.

    greple -ML :+9   # top 10 lines
    greple -ML -9:   # last 10 lines

If forth parameter is given, it describes how many lines is included
in that step cycle.  For example, next command prints top 3 lines in
every 10 lines.

    greple -ML ::10:3

When step count is omitted, forth value is used if available.  Next
command print every 10 lines in group.

    greple -ML :::10 --blockend=-- /etc/services

=item -L=*line numbers*

`-L' is an option to explicitly specify line numbers.  All of the
above commands can be specified using the `-L' option.  The only
difference is that the coloring feature is not automatically disabled.

    greple -ML -L 42
    greple -ML -L 10:20:2
    greple -ML -L :+9

-L option can be used multiple times, like:

    greple -ML -L 42 -L 52 -L 62

But this command produce nothing, because each line definitions are
taken as a different pattern, and greple prints lines only when all
patterns ma...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/A*

%changelog
