%define module_name App-Greple-subst
Epoch: 4
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Greple.pm) perl(App/Greple/update.pm) perl(Data/Section.pm) perl(Data/Section/Simple.pm) perl(Encode.pm) perl(File/Share.pm) perl(Getopt/EX.pm) perl(Getopt/EX/termcolor.pm) perl(Getopt/Long.pm) perl(List/Util.pm) perl(Mo.pm) perl(Module/Build/Tiny.pm) perl(Pod/Usage.pm) perl(Regexp/Assemble.pm) perl(Test/More.pm) perl(Text/VisualPrintf.pm) perl(Text/VisualWidth/PP.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.37
Release: alt1
Summary: Greple module for text search and substitution
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/greple-subst

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This greple module supports check and substitution of text file
using a dictionary file.

Dictionary file is given by --dict option and contains pattern and
expected string pairs.

    greple -Msubst --dict DICT

If the dictionary file contains following data:

    colou?r      color
    cent(er|re)  center

Then above command find the first pattern which does not match the
second string, that is "colour" and "centre" in this case.

Field "//" in dictionary file is ignored, so this file can be written
like this:

    colou?r      //  color
    cent(er|re)  //  center

You can use same file by greple's -f option and string after
"//" is ignored as a comment in that case.

    greple -f DICT ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.deepl-JA.md Changes README.deepl-KO.md LICENSE README.deepl-ZH.md README.md docs
%perl_vendor_privlib/A*
%perl_vendor_privlib/auto/*

%changelog
