%define module_name App-JESP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Cmd.pm) perl(Carp/Always.pm) perl(Class/Load.pm) perl(DBD/Pg.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(DBIx/Simple.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(File/Which.pm) perl(IO/Interactive.pm) perl(IPC/Run.pm) perl(JSON.pm) perl(Log/Any.pm) perl(Moose.pm) perl(SQL/Abstract.pm) perl(String/ShellQuote.pm) perl(String/Truncate.pm) perl(Term/ANSIColor.pm) perl(Test/Most.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.016
Release: alt1
Summary: Just Enough SQL Patches
Group: Development/Perl
License: gpl
URL: https://github.com/jeteve/App-JESP

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JE/JETEVE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Use the command line utility:

  jesp

Or use from your own program (in Perl):

  my $jesp = App::JESP->new({ home => 'path/to/jesphome',
                              dsn => ...,
                              username => ...,
                              password => ...
                            });

  $jsep->install();
  $jesp->deploy();
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\![[:space:]]*\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc README.md LICENSE README Changes
%perl_vendor_privlib/A*
%_bindir/*

%changelog
