%define module_name App-Monport
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Getopt/Long.pm) perl(IO/Socket.pm) perl(List/Util.pm) perl(Nmap/Parser.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.11
Release: alt1
Summary: Monitor network ports for changes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RE/REISINGE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Use this application to find out whether some new ports have been opened (or
existing ones have been closed). More open ports mean bigger attack surface and
consequently higher security risk.

First you should run a base scan, like:

 $ monport base --name "test scan" localhost 192.168.1.0/24

Later on check whether some changes in ports' state took place:

 $ monport diff --name "test scan"
 192.168.1.10 () has changes in port(s) state
  3333 (dec-notes) -- not-open => open

To check regularly create a cronjob like:

 * 21 * * 5      monport diff --name "test scan" --email jdoe@example.com

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/A*
%_man1dir/*
%_bindir/*

%changelog
