BuildRequires: xvfb-run
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(GD/Barcode/QRcode.pm) perl(HTTP/Request.pm) perl(LWP.pm) perl(LWP/Protocol/https.pm) perl(Math/Prime/Util.pm) perl(Mozilla/CA.pm) perl(Test/More.pm) perl(Wx.pm)
# END SourceDeps(oneline)
%def_without test
%define module_name App-NoodlePay
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.007
Release: alt1
Summary: Convenient way to securely send Bitcoin from cold storage
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HASH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
noodlepay.pl (Noodle Pay) enables the use of an air-gapped wallet
running on a device such as a Noodle Air (http://www.noodlepi.com)
to easily and securely send Bitcoin payments.

Noodle Pay is much more convenient to use than hardware wallets, and
doesn't require single-purpose hardware. The Noodle Air device is a
general purpose Linux computer, which can be used for many other
applications as well.

Noodle Pay uses the Electrum wallet's command line mode to create,
sign and publish Bitcoin transactions.

To use Noodle Pay to send Bitcoin from cold storage, you would first
create a cold storage wallet using Electrum on a Noodle Air. Then you
copy the master public key from the Noodle Air to a Noodle Pi, and
create a "watching-only wallet" on the Noodle Pi.

Now you can receive funds to your cold storage wallet and keep track
of them using your watching-only wallet on the Noodle Pi (or any other
computer).

To spend funds from your cold storage wallet, you run noodlepay.pl on
the Noodle Pi, and "noodlepay.pl --offline" on the Noodle Air. Click
"Send" on the Noodle Pi, and enter the amount, scan the destination
address QR code, and enter the transaction fee amount.

A QR code then pops up on the screen, which you scan on the Noodle Air
by clicking "Sign". You're then asked to confirm the transaction, and
if you do a QR code pops up, which you now scan on the Noodle
Pi. You're then asked for confirmation to broadcast the transaction,
and when you click OK it is broadcast.

Your private keys always stay secure on the offline Noodle Air.

Noodle Pay provides a truly mobile, wire-free and convenient cold
storage payment solution. Most hardware wallets require the use of a
desktop or laptop computer, and a USB cable to connect it to the
hardware wallet device.

Compared to other hardware wallet solutions, Noodle Pay also greatly
simplifies physically securing your private keys, and keeping
backups. You can simply pop the MicroSD card out of the Noodle Air,
and keep it physically secure. For backups, you can jus...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%{expand:%%global __find_requires xvfb-run -a %__find_requires}

%files
%doc Changes README
%perl_vendor_privlib/A*
%_bindir/*
%_man1dir/*

%changelog
