# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name App-OCD
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Top-level documentation for CPAN packages in the App::OCD name space
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DM/DMALONE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This page is intented as a top-level introduction to various packages
available in the App::OCD::* name space. I am using this name space to
present various applications and demos that use my Net::OnlineCode
module. That module can be used to implement reliable multicast data
transmission across a network.

The Net::OnlineCode module implements only the basic algorithm
required to enable a sender to be able to construct a series of
"check" blocks from an original message and for the receiver to be
able to combine these check blocks in a certain way to recover the
original message. It does not cover details such as:

=over

=item * how and where the message is stored on the sending side;

=item * XORing of data blocks (the Online Code algorithm is based
completely on such XORs);

=item * the sending and receiving of data blocks over the network;

=item * other network protocol details (such as how transfers are
initiated and how acknowledgements are handled); and

=item * storage (and caching) of check blocks and other intermediate
data needed on the receiving side

=back

Because these data manipulation and networking parts are completely
decoupled from the algorithmic parts, I feel that I need to give some
example applications that include *all* the parts. Rather than
clutter up the Net::OnlineCode module with these examples, I've
decided to release them as separate modules. This will also allow me
to add new demos and evolve them without requiring pointless version
updates to the original module.

For the most part, the demos in this name space will be focused on
*multicast* applications, which is to say that one machine will be
sending data (eg, a data structure or a file) over a network, where it
may be received by multiple receivers at once. Using multicast to send
to multiple receivers like this is very efficient since it only
requires slightly more bandwidth than the equivalent unicast (single
sender, single reciever) file transfers would take.

Some of the demos here will have a single "master" host that does the
sending, while others will focus on more peer-to-peer type
arrangements that don't have any distinguished "master" hosts. Or, to
put it another way, some of the programs will demo "one to many"
transfers, while other will be more "many to many".

I think that multicast (and reliable multicast in particular) is a
very interesting building block for network-based applications, so in
addition to some of the demos that are included simply to provide
examples of how to use the Net::OnlineCode module, I'll also be adding
more complex and feature-laden examples intended as a showcase of the
kinds of cool things that you can do with multicast in general (and
the Online Code algorithm in particular).
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/A*

%changelog
