# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(CGI/Snapp.pm) perl(CGI/Snapp/Dispatch.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Config/Tiny.pm) perl(Cwd.pm) perl(DBI.pm) perl(DBIx/Admin/CreateTable.pm) perl(DBIx/Simple.pm) perl(Data/Session.pm) perl(Data/Verifier.pm) perl(DateTime.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Find.pm) perl(File/ShareDir.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(JSON.pm) perl(JSON/XS.pm) perl(LWP/Simple.pm) perl(Lingua/ENG/Inflect.pm) perl(List/Compare.pm) perl(Log/Handler/Output/DBI.pm) perl(Module/Build.pm)
BuildRequires: perl(Moo.pm) perl(Moo/Role.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Iterator/Rule.pm) perl(Path/Tiny.pm) perl(Perl6/Slurp.pm) perl(Pod/Usage.pm) perl(Socket.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(Text/CSV/Encoded.pm) perl(Text/Xslate.pm) perl(Time/Stamp.pm) perl(Try/Tiny.pm) perl(Types/Standard.pm) perl(Unicode/Collate.pm) perl(YAML/Tiny.pm) perl(charnames.pm) perl(feature.pm) perl(inc/Module/Install.pm) perl(open.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 2.04
%define module_name App-Office-Contacts
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.04
Release: alt1
Summary: A web-based contacts manager
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RS/RSAVAGE/%{module_name}-%{module_version}.tgz
BuildArch: noarch

%description
`App::Office::Contacts' implements a utf8-aware, web-based, private and group contacts manager.

Here 'private' means you can specify which contacts are not to appear in the search results of other
people using the same database. You do this by setting their visibility to 'Just me'.

`App::Office::Contacts' uses the light-weight module the Moo manpage.

Major features:

=over 4

=item o utf8-aware

=item o Any number of people

=item o Any number of organizations

=item o People can have any number of occupations

=item o Organizations can have any number of staff

=item o People and organizations can have any number of notes

These are displayed with the most recent notes first.

=item o Supports using any database server having a Perl interface

This is controlled via a config file.

=item o 1 to 4 email addresses per person or organization

4 was chosen just to limit the amount of screen real estate occupied. It can be easily changed.

=item o 1 to 4 phone numbers per person or organization

=item o Installers can provide their own FAQ page

=item o On-screen information hidden in tabs is updated if appropriate

For example, if you add a person to the staff list for an organization, and the details for that person
are on another, hidden, tab (the organization tab must have the focus), then the list of occupations for
that peson is updated as soon as they are added.

=item o jQuery-style autocomplete is used for various fields

The list of fields which support autocomplete are listed both on the appropriate forms and on the default
FAQ page.

=item o An add-on package supports importing vCards, as probably output by your email client

=item o An add-on package supports donations per person and per organization

But the App::Office::Contacts::Donations manpage has not yet been updated to match V 2.00 of `App::Office::Contacts'.

=back

Screen shots:

The database schema.

Sample search results.

Sample personal details.
The organizational details form is very similar.

%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changelog.ini README Changes docs
%perl_vendor_privlib/A*
%perl_vendor_privlib/auto/*

%changelog
