# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/IniFiles.pm) perl(DBD/Pg.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(PGObject/Util/DBChange.pm) perl(Test/More.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define module_name App-PGMultiDeploy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004001
Release: alt1
Summary: OO deployment to multiple dbs for Pg
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EI/EINHVERFR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package provides a library and a command line utility to run sql scripts
on multiple pg databases relying on two phase commit to ensure the script 
succeeds or fails.  Scripts can only be applied once and the intended use is to
manage schema changes over time in databases subject to row-level logical
replication.

Features:

=over

=item Recovery for partial application

A change file is not re-applied if it has been applied before unless the file
has changed.  This means if another system using PGObject::Util::DBChange 
applies a file to one db, you can still safely use it here.

=item Two phase commit

A change file either commits or rolls back on every database in a group

=item Reuse of libpq tooling

.pgpass etc files work with this tool

=item Logging of failures in separate transaction

=back

Use as a library:

    use App::PGMultiDeploy;

    my $foo = App::PGMultiDeploy->new( config_file => 'path/to/conf.ini',
                                       change_file => 'path/to/change.sql',
                                       dbgroup => 'defined_in_config');
    $foo->deploy;

use as a commandline:

    pg_multideploy --config=/path/to/conf.ini --sql=mychanges.sql --dbgroup=foo

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt README Changes
%perl_vendor_privlib/A*

%changelog
