# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Future.pm) perl(IO/Async.pm) perl(IO/Handle.pm) perl(IO/Socket/UNIX.pm) perl(Moo.pm) perl(MooX/Options.pm) perl(Object/Tap.pm) perl(String/ShellQuote.pm) perl(curry.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define module_version 0.009001
%define module_name App-Procapult
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009001
Release: alt1
Summary: Hand cranked process launcher
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MS/MSTROUT/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The idea for procapult is to have a process launcher that sits around
doing nothing, until you tell it to start something, at which point it
runs that until it exits or you tell it to stop it.

A procapult can, by design, only run one process at once - it's expected
to be started in a screen/tmux/dtach window or an xterm, so the behaviour
is as simple as possible.

To control your procapult, you make a unix socket connection to the
control socket passed when you started it. Multiple clients are permitted
at the same time, and if they step on each others' toes that's considered
operator error on your part.

The protocol for the socket is so simple even I can understand it:

=over 4

=item * On connect, procapult sends its current status

=item * When the status changes, procapult sends the new status

=item * Status lines look like one of

  STATUS: started 12345 some shell process
  STATUS: stopped

where 12345 is the pid of the process procapult is currently running

=item * Valid commands are 'start', 'stop' and 'die'

=item * 'start some shell process' passes the string 'some shell process'
to perl's exec()

=item * 'stop' causes procapult to send its process a SIGHUP

=item * 'die' causes procapult itself to commit harakiri

=item * If your command is malformed or makes no sense, procapult sends
an error line

=item * Error lines look like

  ERROR: some description of what went wrong

=item * A successful command returns nothing, on the assumption that a status
line will be along shortly to tell you what happened

=item * That's all, folks.

=back
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*
%perl_vendor_privlib/P*
%_bindir/*
%_man1dir/*

%changelog
