%define module_name App-Prove-Plugin-MySQLPool
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Prove.pm) perl(Cache/FastMmap.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(Module/Build/Tiny.pm) perl(Mouse.pm) perl(POSIX/AtFork.pm) perl(Test/Requires.pm) perl(Test/mysqld.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: pool of Test::mysqld-s reused while testing
Group: Development/Perl
License: perl
URL: https://github.com/mackee/App-Prove-Plugin-MySQLPool

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MACOPY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
App::Prove::Plugin::MySQLPool is a the prove manpage plugin to speedup your tests using a pool of the Test::mysqld manpages.

If you're using Test::mysqld, and have a lot of tests using it, annoyed by the mysql startup time slowing your tests, this module is for you.

This module launches -j number of Test::mysqld instances first.

Next, each mysqld instance optionally calls

    MyApp::Test::DB->prepare( $mysqld );

You can CREATE TABLEs using the GitDDL manpage or the DBIx::Class::Schema::Loader manpage or others,
or bulk insert master data before start testing.

MyApp::Test::DB only needs to implement a `prepare' sub.
`prepare' is called only once per -j number of mysqld instances,
and is called before your first .t file get tested.

    # MyApp::Test::DB
    sub prepare {
        my ($package, $mysqld) = @_;
        my $gd = GitDDL->new( dsn => $mysqld->dsn, ... );
        $gd->deploy;
    }

Use $ENV{ PERL_TEST_MYSQLPOOL_DSN } like following in your test code.

    my $dbh = DBI->connect( $ENV{ PERL_TEST_MYSQLPOOL_DSN } );

Since this module reuses mysqlds,
you'd better erase all rows inserted at the top of your tests.

    $dbh->do( "TRUNCATE $_" ) for @tables;


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/A*
%perl_vendor_privlib/T*

%changelog
