%define module_name App-Prove-Plugin-TermTableStty
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Env.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Which.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Set the size of the console for Term::Table using stty size
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/App::Prove::Plugin::TermTableStty

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Some of the the Test2::Tools manpage provide some pretty tables for comparing deltas from failed tests.  It tries to 
detect the size of the terminal so that long lines can be wrapped and the tables remain readable.  Unfortunately
when you run the tests under `prove', `stdout' is redirected to a non-terminal and the size of the terminal
cannot be detected.  This plugin will detect the size of the terminal using `/dev/tty' instead of `stdout' and
set the appropriate environment variable so that tables can be printed to use the entire terminal diameter.

I understand why 80 columns is the default for when you do not know the size of a terminal, but really who here 
in 2018 is actually using an 80 column display?  sigh.

This module is similar to the App::Prove::Plugin::TermTableStty manpage but has fewer prereqs and requires a platform that
supports the `stty size' command.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE author.yml Changes
%perl_vendor_privlib/A*

%changelog
