Epoch: 1
%define module_name App-Qmail-DMARC
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Mail/Address.pm) perl(Mail/DKIM/Verifier.pm) perl(Mail/DMARC/PurePerl.pm) perl(Mail/Header.pm) perl(Mail/Qmail/Queue/Message.pm) perl(Mail/SPF.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.7
Release: alt2
Summary: dmarc - verify using DMARC and queue a mail message for delivery
Group: Development/Perl
License: artistic_2
URL: https://github.com/fany/App-Qmail-DMARC

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FA/FANY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
qmail-dmarc is designed to be called by qmail-smtpd instead of qmail-queue
and will verify if incoming e-mail conforms to the DMARC policy of its
sender domain:

=over 4

=item 1.

If the environment variable `RELAYCLIENT' exists, no verification is done,
and the e-mail is immediately passed to `qmail-queue'.

=item 2.

In any other case, we check if the message contains a valid DKIM signature
matching the domain of the `From:' header field.
If this is the case, the e-mail is passed to `qmail-queue'.

=item 3.

If not, but the message has a `From:' domain contained in
`/var/qmail/control/rcpthosts' and the environment variable `DMARC_REJECT'
is set to a true value, the message is rejected with message
`554 Valid DKIM signature required for sender domain ...'

=item 4.

If not, a SPF check is done, and a `Received-SPF:' header field is added to
the message.
Then we check if the message is aligned with its sender's DMARC policy.
A `DMARC-Status:' header field is added.

If the message does not align to the policy, the policy advises to reject such
messages and when the environment variable `DMARC_REJECT' is set to a true
value, the message will be rejected with `554 Failed DMARC test.'

=item 5.

In any other case the message is passed on to `qmail-queue'.

=back

Diagnostic messages are written as a single line to standard error,
so you should find them in your `qmail-smtpd''s log.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%_man1dir/*
%perl_vendor_privlib/M*
%perl_vendor_privlib/A*
%_bindir/*

%changelog
